<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller
{
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles Dashboard.
    |
    */
    public function __construct()
    {
        parent::__construct();
        $this->load->library('auth');
        $this->load->database();
        $this->auth->route_access();
        $this->load->model('autocomplete');
        $this->load->model('university');
        $this->load->model('user');
    }

    /**
     * Display a Dashboard.
     *
     * @return mixed
     */
    public function index()
    {
//        if (in_array('1',$this->auth->roles())){
        if (hasRole('superadmin')){
            
//            $this->load->model('permission');
//            $this->load->model('role');
//            $this->role->addPermissions(1, 1);
//            $this->permission->add([
//                'name' => 'add-university',
//                'display_name' => 'Create University',
//                'status' => 1,
//            ]);
            
//            $this->load->model('role');
//            $this->role->add([
//                'name' => 'editor',
//                'display_name' => 'editor',
//                'description' => 'Editor can edit and   publish posts',
//                'status' => 1,
//                ]);
//            $this->load->library('encryption');
//            $this->load->model('user');
//            $this->user->add([
//                    'name' => 'Likhon',
//                    'username' => 'likhon',
//                    'password' => 'lakmal',
//                    'status' => 1,
//                    ]);
        
            
    
            
            $page_data['page_name'] = 'dashboard';
            $page_data['page_title'] = 'Superadmin Dashboard';
            $page_data['user_role'] = 'superadmin';
            $page_data['controller_name'] = 'home';
            $page_data['func_name'] = 'index';
            // get the university name of the user
            $page_data['university_name'] = $this->user->get_universityname($_SESSION['userID']);
            return $this->load->view('backend/index', $page_data);     
        }
        
        elseif (hasRole('uniadmin')) {
            $page_data['page_name'] = 'dashboard';
            $page_data['page_title'] = 'Uniadmin Dashboard';
            $page_data['user_role'] = 'uniadmin';
            $page_data['controller_name'] = 'home';
            $page_data['func_name'] = 'index';
            
            // get the university name of the user
            $page_data['university_name'] = $this->user->get_universityname($_SESSION['userID']);
            
            return $this->load->view('backend/index', $page_data);
        
    }
        
        else {
            if($this->auth->logout())
            return redirect(base_url().'login', 'refresh');

            return false;
        }
        
    }
    
    public function create_university() {
        $page_data['page_name'] = 'create_university';
        $page_data['page_title'] = 'Add University';
        $page_data['user_role'] = 'superadmin';
        $page_data['controller_name'] = 'home';
        $page_data['func_name'] = 'create_university'; 
        // get the university name of the user
        $page_data['university_name'] = $this->user->get_universityname($_SESSION['userID']);
        return $this->load->view('backend/index', $page_data);
    }
    
    function get_autocomplete_designation(){
		if (isset($_GET['term'])) {
		  	$result = $this->autocomplete->search_designations($_GET['term']);
		   	if (count($result) > 0) {
		    foreach ($result as $row)
		     	$arr_result[] = $row->name;
		     	echo json_encode($arr_result);
		   	}
		}
	}
        
    function get_autocomplete_section(){
		if (isset($_GET['term'])) {
                    
		  	$result = $this->autocomplete->search_section($_GET['term']);
		   	if (count($result) > 0) {
		    foreach ($result as $row)
		     	$arr_result[] = $row->name;
		     	echo json_encode($arr_result);
		   	}
		}
	}
    
    function add_university() {
        if($_POST) {
            
            
            $result = $this->university->add_university($_POST);
            
            if ($result) {
            $data['university_id'] = $result;
            $data['title'] = $_POST['title'];
            $data['name'] = $_POST['uniadmin-name'];
            $data['username'] = $_POST['uniadmin-email'];
            $password = $this->user->generate_password();
            $email_data['email_address'] = $data['username'];
            $email_data['email_pass'] = $password;
            $this->user->send_email($email_data);
            
            $data['password'] = password_hash($password, PASSWORD_BCRYPT);
            $data['section_id'] = $this->university->add_section($_POST);
            $data['designation_id'] = $this->university->add_designation($_POST);
            $data['status'] = 1;
            $data['created_at'] = date("Y-m-d H:i:s");
            
            $result = $this->university->add_uniadmin($data);
            
            // assign uniadmin role
            $uniadmin['user_id'] = $result;
            $uniadmin['role_id'] = '2';
            $this->university->assign_uniadmin($uniadmin);
            
            
            return redirect(base_url().'home', 'refresh');
           
            }
            else {
                echo "false";
           }
                       
            
            
            
            
        }
    }
    
    public function view_universities() {
        $page_data['page_name'] = 'view_universities';
        $page_data['page_title'] = 'View University';
        $page_data['user_role'] = 'superadmin';
        $page_data['controller_name'] = 'home';
        $page_data['func_name'] = 'view_universities';
        // get the university name of the user
        $page_data['university_name'] = $this->user->get_universityname($_SESSION['userID']);
        return $this->load->view('backend/index', $page_data);
    }
    
    // uniadmin functions
    public function create_store() {
        $page_data['page_name'] = 'create_store';
        $page_data['page_title'] = 'Create Store';
        $page_data['user_role'] = 'uniadmin';
        $page_data['controller_name'] = 'home';
        $page_data['func_name'] = 'create_store';
        // get the university name of the user
        $page_data['university_name'] = $this->user->get_universityname($_SESSION['userID']);
        return $this->load->view('backend/index', $page_data);
    }
    
    public function create_supply_division() {
        $page_data['page_name'] = 'create_supply_division';
        $page_data['page_title'] = 'Create Supply Division';
        $page_data['user_role'] = 'uniadmin';
        $page_data['controller_name'] = 'home';
        $page_data['func_name'] = 'create_supply_division';
        // get the university name of the user
        $page_data['university_name'] = $this->user->get_universityname($_SESSION['userID']);
        return $this->load->view('backend/index', $page_data);
    }
}